'use strict';

const { VisibilityInterfaceApi, VisibilityTestOptions, TextVisibilityOptions } = require('affinity:dom');
const { HandleObject } = require('./handleobject.js')
const Nodes = require('./nodes.js');

class VisibilityInterface extends HandleObject {
    constructor(handle) {
        super(handle);
    }

    get [Symbol.toStringTag]() {
        return 'VisibilityInterface';
    }

    get globalOpacity() {
        return VisibilityInterfaceApi.getGlobalOpacity(this.handle);
    }

    get fillOpacity() {
        return VisibilityInterfaceApi.getFillOpacity(this.handle);
    }

    get isVisibleInExport() {
        return VisibilityInterfaceApi.isVisibleInExport(this.handle);
    }

    get isVisibleInDomain() {
        return VisibilityInterfaceApi.isVisibleInDomain(this.handle);
    }

    testVisibility(options) {
        return VisibilityInterfaceApi.testVisibility(this.handle, options);
    }

    isOpaqueInDomainRectangle(rect) {
        return VisibilityInterfaceApi.isOpaqueInDomainRectangle(rect);
    }

    get node() {
        return Nodes.createTypedNode(VisibilityInterfaceApi.getNode(this.handle));
    }
}

module.exports.VisibilityInterface = VisibilityInterface;
module.exports.VisibilityTestOptions = VisibilityTestOptions;
module.exports.TextVisibilityOptions = TextVisibilityOptions;