'use strict';

const { TransparencyInterfaceApi } = require('affinity:dom');
const { HandleObject } = require('./handleobject.js')
const { FillDescriptor } = require('./fills.js')
const Nodes = require('./nodes.js');

class TransparencyInterface extends HandleObject {
    constructor(handle) {
        super(handle);
    }

    get [Symbol.toStringTag]() {
        return 'TransparencyInterface';
    }

    isOpaqueInDomainRect(rect) {
        return TransparencyInterfaceApi.isOpaqueInDomainRect(this.handle, rect);
    } 

    get fillDescriptor() {
        return new FillDescriptor(TransparencyInterfaceApi.getFillDescriptor(this.handle));
    }

    get isTransparencyNone() {
        return TransparencyInterfaceApi.isTransparencyNone(this.handle);
    }

    get domainTransform() {
        return TransparencyInterfaceApi.getTransparencyToDomainTransform(this.handle);
    }

    get contentType() {
        return TransparencyInterfaceApi.getContentType(this.handle);
    }

    get node() {
        return Nodes.createTypedNode(TransparencyInterfaceApi.getNode(this.handle));
    }

    get isAnchoredToSpread() {
        return this.currentDescriptor.isAnchoredToSpread
    }

    setIsAnchoredToSpread(anchored, applyToAllFills, preview) {
        const node = this.node;
        const doc = node.document;
        return doc.setTransparencyFillIsAnchoredToSpread(anchored, node, {applyToAllFills: applyToAllFills}, preview);
    }

    set isAnchoredToSpread(value) {
        this.setIsAnchoredToSpread(value);
    }
}

module.exports.TransparencyInterface = TransparencyInterface;
