'use strict';

const { TransformInterfaceApi } = require('affinity:dom');
const { HandleObject } = require('./handleobject.js')
const Nodes = require('./nodes.js');

class TransformInterface extends HandleObject {
    constructor(handle) {
        super(handle);
    }

    get [Symbol.toStringTag]() {
        return 'TransformInterface';
    }

    get transform() {
        return TransformInterfaceApi.getTransform(this.handle);
    }

    get unconstrainedTransform() {
        return TransformInterfaceApi.getUnconstrainedTransform(this.handle);
    }

    get frameTextScale() {
        return TransformInterfaceApi.getFrameTextScale(this.handle);
    }

    get storyPinPathTransform() {
        return TransformInterfaceApi.getStoryPinPathTransform(this.handle);
    }

    get prefersAspectRatioLockedResize() {
        return TransformInterfaceApi.prefersAspectRatioLockedResize(this.handle);
    }

    get domainTransform() {
        return TransformInterfaceApi.getTransformToDomainTransform(this.handle);
    }

    get node() {
        return Nodes.createTypedNode(TransformInterfaceApi.getNode(this.handle));
    }
}

module.exports.TransformInterface = TransformInterface;
