'use strict';

const { PhysicalRootPropertiesInterfaceApi } = require('affinity:dom');
const { HandleObject } = require('./handleobject.js');
const Nodes = require('./nodes.js');
const { PageBoxInterface } = require('./pageboxinterface.js');

class PhysicalRootPropertiesInterface extends HandleObject {
    constructor(handle) {
        super(handle);
    }

    get [Symbol.toStringTag]() {
        return 'PhysicalRootPropertiesInterface';
    }

    get pageCount() {
        return PhysicalRootPropertiesInterfaceApi.getPageCount(this.handle);
    }

    get pageBoxInterface() {
        return new PageBoxInterface(PhysicalRootPropertiesInterfaceApi.getPageBoxInterface(this.handle));
    }

    get node() {
        return Nodes.createTypedNode(PhysicalRootPropertiesInterfaceApi.getNode(this.handle));
    }
}

module.exports.PhysicalRootPropertiesInterface = PhysicalRootPropertiesInterface;
