'use strict';

const { CurvesInterfaceApi } = require('affinity:dom');
const { HandleObject } = require('./handleobject.js');
const { PolyCurve } = require('./geometry.js');
const { SubSelectable } = require('./selections.js');
const Nodes = require('./nodes.js');

class CurvesInterface extends HandleObject {
    constructor(handle) {
        super(handle);
    }

    get [Symbol.toStringTag]() {
        return 'CurvesInterface';
    }

    get polyCurve() {
        return new PolyCurve(CurvesInterfaceApi.getCurves(this.handle));
    }

    get corneredPolyCurve() {
        return new PolyCurve(CurvesInterfaceApi.getCorneredCurves(this.handle));
    }

    get windingOrder() {
        return CurvesInterfaceApi.getWindingOrder(this.handle);
    }

    get domainTransform() {
        return CurvesInterfaceApi.getDomainTransform(this.handle);
    }

    getSubSelectableCount(subSelectableType) {
        return CurvesInterfaceApi.getSubSelectableCount(this.handle, subSelectableType);
    }

    getSubSelectable(subSelectableType, index) {
        return new SubSelectable(CurvesInterfaceApi.getSubSelectable(this.handle, subSelectableType, index));
    }

    get node() {
        return Nodes.createTypedNode(CurvesInterfaceApi.getNode(this.handle));
    }
}

module.exports.CurvesInterface = CurvesInterface;
