'use strict';

const {Buffer} = require('/buffer');

function testSlice() {
    const buf = new Buffer(256);
    for (let i = 0; i < buf.length; ++i) {
        buf[i] = i;
    }
    
    let slice = buf.slice(10, 20);
    for (let i = 0; i < slice.length; ++i) {
        console.assert(slice[i] === i + 10);
    }

    slice[0] = 0;
    console.assert(slice[0] === 0);
    console.assert(buf[10] === 10);
}


function testSpan() {
    const buf = new Buffer(256);
    for (let i = 0; i < buf.length; ++i) {
        buf[i] = i;
    }
    
    let span = buf.span(10, 20);
    for (let i = 0; i < span.length; ++i) {
        console.assert(span[i] === i + 10);
    }

    span[0] = 0;
    console.assert(span[0] === 0);
    console.assert(buf[10] === 0);
}


module.exports.runTests = function() {
    testSlice();
    testSpan();
}