'use strict';

const { RasterInterfaceApi } = require('affinity:dom');
const { HandleObject } = require('./handleobject.js')
const { Bitmap, PixelBuffer } = require('./rasterobject.js');
const Nodes = require('./nodes.js');

class RasterInterface extends HandleObject {
    constructor(handle) {
        super(handle)
    }

    get [Symbol.toStringTag]() {
        return 'RasterInterface';
    }

    get width() {
        return RasterInterfaceApi.getWidth(this.handle);
    }

    get height() {
        return RasterInterfaceApi.getHeight(this.handle);
    }

    get format() {
        return RasterInterfaceApi.getFormat(this.handle);
    }

    get pixelSize() {
        return RasterInterfaceApi.getPixelSize(this.handle);
    }

    createCompatibleBitmap(copyContents) {
        return new Bitmap(RasterInterfaceApi.createCompatibleBitmap(this.handle, copyContents));
    }

    createCompatibleBuffer(copyContents) {
        return new PixelBuffer(RasterInterfaceApi.createCompatibleBuffer(this.handle, copyContents));
    }

    copyTo(dest, destRect, srcX, srcY) {
        return RasterInterfaceApi.copyTo(this.handle, dest.handle, destRect, srcX, srcY);
    }
    
    get node() {
        return Nodes.createTypedNode(RasterInterfaceApi.getNode(this.handle));
    }
}

module.exports.RasterInterface = RasterInterface;
