'use strict';

const { PageBoxInterfaceApi } = require('affinity:dom');
const { HandleObject } = require('./handleobject.js');
const Nodes = require('./nodes.js');

class PageBoxInterface extends HandleObject {
    constructor(handle) {
        super(handle);
    }

    get [Symbol.toStringTag]() {
        return 'PageBoxInterface';
    }

    getPageBoundingBox(pageBoundingBoxType) {
        return PageBoxInterfaceApi.getPageBoundingBox(this.handle, pageBoundingBoxType);
    }

    get node() {
        return Nodes.createTypedNode(PageBoxInterfaceApi.getNode(this.handle));
    }
}

module.exports.PageBoxInterface = PageBoxInterface;
