'use strict';

const { RasterExtendType, RasterFormat, RasterIntent, RasterObjectApi, RasterObjectType, RasterResamplerType } = require('affinity:raster');
const { HandleObject } = require('./handleobject.js')

class RasterObject extends HandleObject {
    constructor(handle) {
        super(handle)
    }

    get [Symbol.toStringTag]() {
        return 'RasterObject';
    }

    get width() {
        return RasterObjectApi.getWidth(this.handle);
    }

    get height() {
        return RasterObjectApi.getHeight(this.handle);
    }

    get format() {
        return RasterObjectApi.getFormat(this.handle);
    }

    get pixelSize() {
        return RasterObjectApi.getPixelSize(this.handle);
    }
    
    get type() {
        return RasterObjectApi.getType(this.handle);
    }

    createCompatibleBitmap(copyContents) {
        return new Bitmap(RasterObjectApi.createCompatibleBitmap(this.handle, copyContents));
    }

    createCompatibleBuffer(copyContents) {
        return new PixelBuffer(RasterObjectApi.createCompatibleBuffer(this.handle, copyContents));
    }

    copyTo(dest, destRect, srcX, srcY) {
        return RasterObjectApi.copyTo(this.handle, dest.handle, destRect, srcX, srcY);
    }

    get buffer() {
        return RasterObjectApi.getArrayBuffer(this.handle);
    }
	
	clone() {
		return new RasterObject(RasterObjectApi.clone(this.handle));
	}
	
	cloneEmpty() {
		return new RasterObject(RasterObjectApi.cloneEmpty(this.handle));
	}
}

class Bitmap extends RasterObject {
    
    constructor(handle) {
        super(handle);
    }

    get [Symbol.toStringTag]() {
        return 'Bitmap';
    }

    static create(width, height, format) {
        return new Bitmap(RasterObjectApi.createBitmap(width, height, format));
    }
}

class PixelBuffer extends RasterObject {
    
    constructor(handle) {
        super(handle);
    }

    get [Symbol.toStringTag]() {
        return 'PixelBuffer';
    }

    static create(width, height, format) {
        return new PixelBuffer(RasterObjectApi.createPixelBuffer(width, height, format));
    }
}

class NodeRenderingEngine extends RasterObject {

	constructor(handle) {
		super(handle);
	}

	get [Symbol.toStringTag]() {
		return 'NodeRenderingEngine';
	}

	static createDefault(node, format) {
		return new NodeRenderingEngine(RasterObjectApi.createDefaultNodeRenderingEngine(node.handle, format));
	}

	static create(node, format, options) {
		return new NodeRenderingEngine(RasterObjectApi.createNodeRenderingEngine(node.handle, format, options));
	}
}

module.exports.RasterObject = RasterObject;
module.exports.Bitmap = Bitmap;
module.exports.PixelBuffer = PixelBuffer;
module.exports.NodeRenderingEngine = NodeRenderingEngine;
module.exports.RasterExtendType = RasterExtendType;
module.exports.RasterFormat = RasterFormat;
module.exports.RasterIntent = RasterIntent;
module.exports.RasterObjectType = RasterObjectType;
module.exports.RasterResamplerType = RasterResamplerType;
