'use strict';

const { PictureFrameInterfaceApi } = require('affinity:dom');
const { HandleObject } = require('./handleobject.js')
const Nodes = require('./nodes.js');

class PictureFrameInterface extends HandleObject {
    constructor(handle) {
        super(handle);
    }

    get [Symbol.toStringTag]() {
        return 'PictureFrameInterface';
    }

    get enabled() {
        return PictureFrameInterfaceApi.isPictureFrameEnabled(this.handle);
    }

    get description() {
        return PictureFrameInterfaceApi.getPictureFrameDescription(this.handle);
    }
    
    get hasFrameContents() {
        return PictureFrameInterfaceApi.hasFrameContents(this.handle);
    }
    
    get frameContents() {
        return PictureFrameInterfaceApi.getFrameContents(this.handle);
    }
    
    get pictureFrameAnchor() {
        return PictureFrameInterfaceApi.getPictureFrameAnchor(this.handle);
    }
    
    get clearFillOnPopulate() {
        return PictureFrameInterfaceApi.getClearFillOnPopulate(this.handle);
    }
    
    get originalContentsRect() {
        return PictureFrameInterfaceApi.getOriginalContentRect(this.handle);
    }
    
    get dataMergeFieldId() {
        return PictureFrameInterfaceApi.getDataMergeFieldId(this.handle);
    }
    
    calculateAnchor(node, hint) {
        return PictureFrameInterfaceApi.calculateAnchor(this.handle, node.handle, hint);
    }
    
    calculateConstraints(node, hint) {
        return PictureFrameInterfaceApi.calculateConstraints(this.handle, node.handle, hint);
    }

    get node() {
        return Nodes.createTypedNode(PictureFrameInterfaceApi.getNode(this.handle));
    }
}

module.exports.PictureFrameInterface = PictureFrameInterface;
