'use strict';

const { ArtboardPropertiesApi, EffectiveMarginBehaviour } = require('affinity:dom');
const { HandleObject } = require('./handleobject.js');
const { MarginsInterface } = require('./marginsinterface.js');
const { PhysicalRootPropertiesInterface } = require('./physicalrootpropertiesinterface.js');
const Nodes = require('./nodes.js');

class ArtboardProperties extends HandleObject {
    constructor(handle) {
        super(handle);
    }

    get isArtboardProperties() {
        return true;
    }

    getMarginBox(behaviour) {
        return ArtboardPropertiesApi.getMarginBox(this.handle, behaviour);
    }

    get marginsFill() {
        return new FillDescriptor(ArtboardPropertiesApi.getMarginFill(this.handle));
    }
    
    get marginsInterface() {
        return new MarginsInterface(ArtboardPropertiesApi.getMarginsInterface(this.handle));
    }
    
    get physicalRootPropertiesInterface() {
        return new PhysicalRootPropertiesInterface(ArtboardPropertiesApi.getPhysicalRootPropertiesInterface(this.handle));
    }

    get node() {
        return Nodes.createTypedNode(ArtboardPropertiesApi.getNode(this.handle));
    }
}

module.exports.ArtboardProperties = ArtboardProperties;
module.exports.EffectiveMarginBehaviour = EffectiveMarginBehaviour;
