'use strict';

const { ArtboardInterfaceApi } = require('affinity:dom');
const { ArtboardProperties } = require('./artboardproperties.js');
const { HandleObject } = require('./handleobject.js');
const { PhysicalRootInterface } = require('./physicalrootinterface.js');
const Nodes = require('./nodes.js');

class ArtboardInterface extends HandleObject {
    constructor(handle) {
        super(handle);
    }

    get [Symbol.toStringTag]() {
        return 'ArtboardInterface';
    }

    isSameObject(other) {
        return ArtboardInterfaceApi.isSameObject(this.handle, other.handle);
    }

    get isArtboardInterface() {
        return true;
    }

    get isArtboardEnabled() {
        return ArtboardInterfaceApi.isArtboardEnabled(this.handle);
    }

    get description() {
        return ArtboardInterfaceApi.getArtboardDescription(this.handle);
    }
    
    get baseBox() {
        return ArtboardInterfaceApi.getBaseBox(this.handle);
    }
    
    get spreadBaseBox() {
        return ArtboardInterfaceApi.getSpreadBaseBox(this.handle);
    }
    
    get topOfPageMargin() {
        return ArtboardInterfaceApi.getTopOfPageMargin(this.handle);
    }

    get artboardProperties() {
        return new ArtboardProperties(ArtboardInterfaceApi.getArtboardProperties(this.handle));
    }

    get node() {
        return Nodes.createTypedNode(ArtboardInterfaceApi.getNode(this.handle));
    }
    
    #physicalRootInterface;
    get physicalRootInterface() {
        if (!this.#physicalRootInterface)
            this.#physicalRootInterface = new PhysicalRootInterface(ArtboardInterfaceApi.getPhysicalRootInterface(this.handle));
        return this.#physicalRootInterface;
    }
    
    get physicalRootProperties() {
        return this.physicalRootInterface.physicalRootProperties;
    }
    
    get pageCount() {
        return this.physicalRootProperties.pageCount;
    }
}

module.exports.ArtboardInterface = ArtboardInterface;
