'use strict';

const { Document } = require('./document.js');
const { ApplicationApi } = require('affinity:application');
const { UiApi } = require('affinity:ui');

class AppDocuments {
    get [Symbol.toStringTag]() {
        return 'AppDocuments';
    }
    
    get all() {
        return Document.all;
    }
    
    get current() {
        return Document.current;
    }

    load(path) {
        return Document.load(path);
    }
}

class Application {
    #documents;

    constructor() {
        this.#documents = new AppDocuments();
    }

    get [Symbol.toStringTag]() {
        return 'Application';
    }
    
    get documents() {
        return this.#documents;
    }
    
    alert(message, title) {
        return UiApi.alert(message, title);
    }
    
    confirm(message, title) {
        return UiApi.confirm(message, title);
    }
    
    prompt(message, title) {
        return UiApi.prompt(message, title);
    }
    
    chooseFile() {
        return UiApi.chooseFile();
    }
    
    alertAsync(message, title, callback) {
        UiApi.alertAsync(message, title, callback);
    }
    
    confirmAsync(message, title, callback) {
        UiApi.confirmAsync(message, title, callback);
    }
    
    promptAsync(message, title, callback) {
        UiApi.promptAsync(message, title, callback);
    }
    
    chooseFileAsync(callback) {
        UiApi.chooseFileAsync();
    }

    get compileDate() {
        return ApplicationApi.getCompileDate();
    }

    get platformName() {
        return ApplicationApi.getPlatformName();
    }

    get shortVersion() {
        return ApplicationApi.getShortVersion();
    }

    get version() {
        return ApplicationApi.getVersion();
    }

    get buildVersion() {
        return ApplicationApi.getBuildVersion();
    }

    get majorVersion() {
        return ApplicationApi.getMajorVersion();
    }

    get minorVersion() {
        return ApplicationApi.getMinorVersion();
    }

    get revisionVersion() {
        return ApplicationApi.getRevisionVersion();
    }

    get applicationMode() {
        return ApplicationApi.getApplicationMode();
    }

    get buildKind() {
        return ApplicationApi.getBuildKind();
    }

    get productCopyrightMessage() {
        return ApplicationApi.getProductCopyrightMessage();
    }

    get productFullName() {
        return ApplicationApi.getProductFullName();
    }

    get productLongName() {
        return ApplicationApi.getProductLongName();
    }

    get productPrimaryFileExtension() {
        return ApplicationApi.getProductPrimaryFileExtension();
    }

    get productVersionName() {
        return ApplicationApi.getProductVersionName();
    }

    get productShortName() {
        return ApplicationApi.getProductShortName();
    }

    get suiteFullName() {
        return ApplicationApi.getSuiteFullName();
    }

    get uiParadigm() {
        return ApplicationApi.getUIParadigm();
    }
    
    get argC() {
        return ApplicationApi.getArgC();
    }
    
    get argV() {
        return ApplicationApi.getArgV();
    }
}

module.exports.app = new Application();
