'use strict';

const { BaseBoxInterfaceApi } = require('affinity:dom');
const { HandleObject } = require('./handleobject.js');
const Nodes = require('./nodes.js')

class BaseBoxInterface extends HandleObject {
    constructor(handle) {
        super(handle);
    }

    get isBaseBoxInterface() {
        return true;
    }

    get baseBox() {
        return BaseBoxInterfaceApi.getBaseBox(this.handle);
    }

    get constrainingBaseBox() {
        return BaseBoxInterfaceApi.getConstrainingBaseBox(this.handle);
    }

    get node() {
        return Nodes.createTypedNode(BaseBoxInterfaceApi.getNode(this.handle));
    }
}

module.exports.BaseBoxInterface = BaseBoxInterface;
